library(xml2)

### RStudio-based path location of the current directory. Please, adapt if needed
library(rstudioapi)
setwd(dirname(rstudioapi::getSourceEditorContext()$path))

### create the namespace definition file
ns_qual <- xml_ns_rename(xml_ns(read_xml("<root>
                                          <core xmlns = \"http://www.sbml.org/sbml/level3/version1/core\"/>
                                          <qual xmlns = \"http://www.sbml.org/sbml/level3/version1/qual/version1\"/>
                                        </root>")), 
                         d1 = "sbml", d2 = "qual")

### Read in the input document, below an example
qual_xml <- read_xml("U-P.sbml")

### List the nodes with inputlists
list_of_nodes <- xml_find_all(qual_xml, "//qual:listOfInputs", ns = ns_qual)

### Nodes that have text in them are to be removed, as they contain no <qual:input/> nodes
empty_nodes <- sapply(list_of_nodes, xml_text) != ""

### Go through empty <qual:listOfInputs> nodes, remove their parents (qual:transitions)
sapply(list_of_nodes[empty_nodes], function(x) xml_remove(xml_parent(x)))

### Save the resulting document
write_xml(qual_xml, "out.sbml")
